# Contributing to silentbridge
We want to make contributing to this project as easy and transparent as
possible.

## Our Development Process
We use GitHub to sync code to and from our internal repository. We'll use GitHub
to track issues and feature requests, as well as accept pull requests.

## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints (we use PEP8).

## Issues
We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

## Coding Style  
* 4 spaces for indentation rather than tabs
* 80 character line length
* Use [pylint](https://www.pylint.org/) to conform to our lint rules (PEP8)

## License
By contributing to silentbridge, you agree that your contributions will be licensed
under its GPLv3 license.
